import java.awt.*;
import java.awt.event.*;


/** Demonstrate the use of class Shape and its subclasses */
public class DemoShapes extends Frame {

	public static void main(String args[])  {
	System.out.println( "Hello World!" );
     DemoShapes d= new DemoShapes();
     d.setBounds(10, 10, 250, 250);
     d.show();
     // Tell the program to exit upon closure of this window
        d.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
              System.exit(0);}});
     System.out.println("Program started");
   }

   /** Paint some shapes */
   public void paint(Graphics g) {
     g.translate(getInsets( ).left, getInsets( ).top);
     
     int h= 30; // length of horizontal side of parallelogram
     int v= 50; // length of other side of parallelogram
     int d= 20; // distance from (x,y) to horizontal line
     int x= 90; // (x,y) is the coordinate
     int y= 20; // of top-left point
     
     // vertical distance to bottom of parallelogram
     int vert= (int)Math.round(Math.sqrt(v*v - d*d));
     
     g.setColor(Color.red);
     Shape s1= new Parallelogram(x, y, h, v, -d);
     s1.drawShape(g);
     System.out.println(s1);
     
     Shape s2= new Parallelogram(x-d-h, y, h, v, d);
     s2.drawShape(g);
     System.out.println(s2);
     
     Shape s3= new Parallelogram(x, y+vert, h, v, d);
     s3.drawShape(g);
     System.out.println(s3);
     
     Shape s4= new Parallelogram(x-d-h, y+vert, h, v, -d);
     s4.drawShape(g);
     System.out.println(s4);
   
     g.setColor(Color.green);
     Shape s5= new Square(x-h, y+2*vert, 2*h);
     s5.drawShape(g);
     System.out.println(s5);
     
     g.setColor(Color.blue);
     Shape s6= new Rhombus(x, y + 2*vert + 2*h, h, -10);
     s6.drawShape(g);
     System.out.println(s6);
     
     Shape s7= new Rhombus(x-h-10, y + 2*vert + 2*h, h, 10);
     s7.drawShape(g);
     System.out.println(s7);
    
     g.setColor(Color.black);
     g.drawLine(x+h+d, y+vert, x+h, y + 2*vert + 2*h);
     g.drawLine(x-h-d, y+vert, x-h, y + 2*vert + 2*h);
   }
}
